<?php

/* ================= CONFIG ================= */

$base_dir = "/home/kaptphoe/loginkaptenasia.autos/";
$domain   = "amp";   // folder output AMP
$template = "amp.html";
$csv_file = "pages.csv";

/* ================= READ CSV ================= */

function read_csv($file) {

    $rows = [];

    if (!file_exists($file)) {
        die("CSV tidak ditemukan.\n");
    }

    if (($handle = fopen($file, "r")) !== false) {

        // skip header
        fgetcsv($handle, 0, "|");

        while (($data = fgetcsv($handle, 0, "|")) !== false) {

            if (count($data) < 8) continue;

            $rows[] = [
                'filename'    => trim($data[0]),
                'keyword'     => trim($data[1]),
                'title'       => trim($data[2]),
                'description' => trim($data[3]),
                'article'     => trim($data[4]),
                'image'       => trim($data[5]),
                'canonical'   => trim($data[6]),
                'amp'         => trim($data[7]),
            ];
        }

        fclose($handle);
    }

    return $rows;
}

/* ================= GENERATE ================= */

function build_amp($rows, $base_dir, $domain, $template) {

    if (!file_exists($template)) {
        die("Template amp.html tidak ditemukan.\n");
    }

    $tpl = file_get_contents($template);

    foreach ($rows as $row) {

        $target_dir  = $base_dir . $domain . '/' . $row['filename'] . '/';
        $target_file = $target_dir . 'index.html';

        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0755, true);
        }

        $output = str_replace(
            ['{{filename}}','{{keyword}}','{{title}}','{{description}}','{{article}}','{{image}}','{{canonical}}','{{amp}}'],
            [
                $row['filename'],
                $row['keyword'],
                $row['title'],
                $row['description'],
                $row['article'],
                $row['image'],
                $row['canonical'],
                $row['amp'],
            ],
            $tpl
        );

        file_put_contents($target_file, $output);

        echo "AMP Generated: $target_file\n";
    }
}

/* ================= EXECUTE ================= */

$data = read_csv($csv_file);
echo "Total AMP: " . count($data) . "\n";

build_amp($data, $base_dir, $domain, $template);

echo "AMP SELESAI\n";